﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Data.Linq;
using System.Linq.Expressions;
using System.Text;
using System.Web;
using System.Web.UI;
using System.Text.RegularExpressions;
using System.Globalization;
using System.Threading;
using System.Reflection;

namespace VIRP
{
    public static class NonLINQExtensions
    {
        /// <summary>
        /// extension method for single character repetition
        /// </summary>
        /// <param name="chatToRepeat">Character to repeat</param>
        /// <param name="repeat">How many times</param>
        /// <returns></returns>
        public static string Repeat(this char chatToRepeat, int repeat)
        {
            return new string(chatToRepeat, repeat);
        }

        /// <summary>
        /// extension method for string pattern repetition 
        /// </summary>
        /// <param name="stringToRepeat">String to repeat</param>
        /// <param name="repeat">How many times</param>
        /// <returns></returns>
        public static string Repeat(this string stringToRepeat, int repeat)
        {
            var builder = new StringBuilder(repeat);
            for (int i = 0; i < repeat; i++)
            {
                builder.Append(stringToRepeat);
            }
            return builder.ToString();
        }

        /// <summary>
        /// extension method for redirect syntax improvement
        /// </summary>
        /// <param name="response">The System.Web.HttpResponse 
        /// to which this method is added.</param>
        /// <param name="newUrl">The target location containing a 
        /// composite format string.</param>
        /// <param name="args">A System.Object to format.</param>
        public static void Redirect(this System.Web.HttpResponse response, string newUrl, params object[] args)
        {
            HttpContext.Current.Response.Redirect(string.Format(newUrl, args));
        }

        /// <summary>
        /// enumerates all controls for a given container
        /// </summary>
        /// <param name="parent">parent container</param>
        /// <returns></returns>
        public static IEnumerable<Control> GetAllControls(this Control parent)
        {
            foreach (Control control in parent.Controls)
            {
                yield return control;
                foreach (Control descendant in control.GetAllControls())
                {
                    yield return descendant;
                }
            }
        }
        /// <summary>
        /// Extension method to return specified length of last characters from a string
        /// </summary>
        /// <param name="stringFrom"></param>
        /// <param name="length">Number of characters</param>
        /// <returns></returns>
        public static string LastChars(this string stringFrom, int length)
        {
            if (string.IsNullOrEmpty(stringFrom)) return string.Empty;
            if (stringFrom.Length < length) return string.Empty;
            return stringFrom.Substring(stringFrom.Length - length, length);
        }

        /// <summary>
        /// Extension method to split sring by a pattern
        /// </summary>
        /// <param name="input">original string</param>
        /// <param name="delimiter">pattern for split</param>
        /// <returns></returns>
        public static string[] Split(this string input, string delimiter)
        {
            return Regex.Split(input, delimiter);
        }

        /// <summary>
        /// Extension method to convert a string to proper casing
        /// </summary>
        /// <param name="input"></param>
        /// <returns></returns>
        public static string ToTitleCase(this string input)
        {
            string result = String.Empty;
            try
            {
                TextInfo textInfo = Thread.CurrentThread.CurrentCulture.TextInfo;
                result = textInfo.ToTitleCase(input.ToLower());
            }
            catch
            {
                result = input;
            }

            return result;
        }

        /// <summary>
        /// Extension string to split string by separator and preventing
        /// and preventing split on escape character
        /// </summary>
        /// <param name="input"></param>
        /// <param name="separator"></param>
        /// <param name="escapeCharacter"></param>
        /// <returns></returns>
        public static IEnumerable<string> Split(this string input,
                                        string separator,
                                        char escapeCharacter)
        {
            int startOfSegment = 0;
            int index = 0;
            while (index < input.Length)
            {
                index = input.IndexOf(separator, index);
                if (index > 0 && input[index - 1] == escapeCharacter)
                {
                    index += separator.Length;
                    continue;
                }
                if (index == -1)
                {
                    break;
                }
                yield return input.Substring(startOfSegment, index - startOfSegment).Replace(escapeCharacter.ToString(), String.Empty);
                index += separator.Length;
                startOfSegment = index;
            }
            yield return input.Substring(startOfSegment).Replace(escapeCharacter.ToString(), String.Empty);
        }

        /// <summary>
        /// Will get the string value for a given enums value, this will
        /// only work if you assign the StringValue attribute to
        /// the items in your enum.
        /// </summary>
        /// <param name="value"></param>
        /// <returns></returns>
        //public static string GetStringValue(this Enum value)
        //{
        //    // Get the type
        //    Type type = value.GetType();

        //    // Get fieldinfo for this type
        //    FieldInfo fieldInfo = type.GetField(value.ToString());

        //    // Get the stringvalue attributes
        //    StringValueAttribute[] attribs = fieldInfo.GetCustomAttributes(
        //        typeof(StringValueAttribute), false) as StringValueAttribute[];

        //    // Return the first if there was a match.
        //    if (attribs != null && attribs.Length > 0)
        //    {
        //        return attribs[0].StringValue;
        //    }
        //    else
        //    {
        //        return null;
        //    }
        //}

        public static bool IsNullOrEmpty(this string str)
        {
            return String.IsNullOrEmpty(str);
        }

        /// <summary>
        /// convenience method for !String.IsNullOrEmpty syntax
        /// </summary>
        /// <param name="str"></param>
        /// <returns></returns>
        public static bool NotNullOrEmpty(this string str)
        {
            return !String.IsNullOrEmpty(str);
        }

        /// <summary>
        /// In CamelCase, adds spaces prior to each Upper Case Character
        /// </summary>
        /// <param name="s"></param>
        /// <returns></returns>
        public static string AddSpacesToCamelCase(this string s)
        {
            //if (s.Length == 0)
            //{
            //    return "";
            //}
            //else
            //{
            //    StringBuilder sb = new StringBuilder();

            //    for (int i = 0; i < s.Length; i++)
            //    {
            //        if (i>0 && char.IsUpper(s[i]))
            //        {
            //            sb.Append(" ");
            //        }

            //        sb.Append(s[i]);
            //    }
            //    return sb.ToString();
            //}

            if (string.IsNullOrEmpty(s))
                return string.Empty;

            var words = Regex.Split(s, "(?=[A-Z])");

            return words.Length <= 1 ? s : String.Join(" ", words);
        }

        /// <summary>
        /// https://stackoverflow.com/questions/444798/case-insensitive-containsstring
        /// </summary>
        public static bool Contains(this string source, string toCheck, StringComparison comp)
        {
            if (source == null) return false;

            return source.IndexOf(toCheck, comp) >= 0;
        }
    }
}
